---
title: Lecture 4：被动语态
tags:
  - 英语
  - 语法
categories: 
date: 2024-03-04
---
---
## 4.1 什么是语态
**分为两周**
+ 主动语态
	+ 主语主动发出动作；
	+ *I eat apples*
+ 被动语态
	+ 主语被发出动作
	+ *Apples are eaten.*
+ 注意：如果语态是被动的，则需要使用被动语态；否则都是用动词本身，即主动语态

### 4.1.1 被动语态的构成
**构成**：$be+done$
+ `done`：表示被动的动作；
+ `be`：
	+ 1. 使用 `be` 来表示被动的时间；
		+ 被动语态当中体现时间，不可以更改 `done`，而是更改 `be`；
	+ 2. 使用 `be` 来表示主语的单复数；
+ 强调动作的发生者时：**be done + by 动作的发出者**


**方法**：三步法分析被动语态
+ 1. 被动的动作；
+ 2. 被动的时间；
+ 3. 主语的单复数；

**举例**：*不幸的是，这些评论家现在都被遗忘了。*
+ 1. 被动的动作：forgotten；
+ 2. 被动的时间，现在；
+ 3. 主语的单复数：因为是很多评论家，因此使用 are；
+ 最后：*Unfortunately, these critics are forgotten.* 

**注意：** 英语当中的被动，翻译成中文时，**可以翻译成主动、也可以翻译成被动**，而且有时即使意思是**被**，但也不一定要加**被**字；
+ 教室打扫完了 = 教师被打扫完了（这个**被**不需要加）；

### 4.1.2 被动语态与时态结合
**常见的八种时态都有对应的被动语态**
+ 一般时态
	+ 这些评论家（过去）被遗忘了。
		+ These critics were forgotten.
	+ 这些评论家（现在）被遗忘了。
		+ These critics are forgotten.
	+ 这些评论家将会 (现在的将来)被遗忘。
		+ These critics will be forgotten.
	+ 这些评论家过去将会 (过去的将来)被遗忘。
		+ These critics would be forgotten.
+ 进行时态
	+ 这些评论家过去正在被遗忘。
		+ These critics were being forgotten.
	+ 这些评论家现在正在被遗忘。
		+ These critics are being forgotten.
+ 完成时态
	+ 这些评论家过去已经 (过去的之前)被遗忘了。
		+ These critics had been forgotten.
	+ 这些评论家现在已经（现在的之前）被遗忘了。
		+ These critics have been forgotten.
+ 总结：**被动语态分析 be** 
	+ 主动的时态当中，时态变化时**改变动词**；
	+ 被动的时态当中，时态变化时**改变 be**；

### 4.1.3 被动语态与情态结合
**构成**
+ 情态动词 + be done = 被动语态与情态结合；

**举例**
+ *In the internet age, at least in theory, this fraction <u>can be muchreduced</u>.*
+ *Those first few days should be spent looking for work*
	+ 最初的几天应该被消耗在寻找工作上；

## 4.2 为什么要学习被动语态
**被动语态需要重点掌握**

**被动语态非常符合英语的内在逻辑：** 中文习惯以人为主体，而英文可以使用被动语态来展示"以客观事实为主体"。

**写作题型**：被动语态经常用在写作当中；

**翻译题型**：翻译时也经常使用被动语态；

### 4.2.1 考研阅读：同义改写
**经典的出题套路**：对原文的内容，按照同样的意思进行改写；
+ 换词性；
+ 换同义词；
+ 主被动互换；

**举例**
+ 题目：*According to Paragraph 2, the proposal might be regarded by some as  __ .*
+ 在阅读的原文中的对应部分：*Some might see the proposal as a booby prize for the fact that.*

+ 选项：*can be taught to exchange things*
+ 原文：*teaching their monkeys to exchange tokens for food.*

## 4.3 真题演练
**题目**：*“Benefits” <u>have been weighed</u> against “harmful' outcomes.*
+ been done：被动语态；
+ have been weighed：现在完成时的被动语态；
+ 好处，现在的之前已经被权衡了；
+ 被动语态的翻译题：
	+ 1. 如果是翻译题：我认为这事情怎么样 -> 翻译成这事情被认为怎么样；
		+ 如果不是翻译题：直接翻译也可以；
	+ 2. 去掉被字翻译出来；
	+ 3. 用"受到、遭到"代替“被”字；

**题目**：*This theory <u>was known</u> as diffusionism.*

**题目**：*People in earlier eras <u>were surrounded</u> by reminders of misery.*
+ were surrounded：被... 所围绕；

**题目**：*Paid and owned media <u>are controlled</u> by marketers promoting their own products.*
+ are controlled：现在被控制；

